package jp.co.ois.sample.activemqproducer;

import java.io.IOException;
import java.util.Date;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import lombok.extern.slf4j.Slf4j;

@Controller
@Slf4j
public class HogeController {

    @Autowired
    JmsTemplate jmsTemplate;

    @RequestMapping(value = "/")
    @ResponseBody
    public String hello() {
        log.debug("called.");
        jmsTemplate.convertAndSend("hogeQ", "hoge "+ new Date());
        return "hoge!";
    }

    @RequestMapping("/hoge")
    @ResponseBody
    public String hello(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String body = request.getReader().lines().collect(Collectors.joining("\r\n"));
        log.debug("body.length = {}", body.length());
        jmsTemplate.convertAndSend("hogeQ", body);
        return "hoge!";
    }
}
