package jp.co.ois.hoge.springsecurity;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;

import lombok.extern.slf4j.Slf4j;

/**
 * ほげアプリ.
 */
@SpringBootApplication
@EnableWebSecurity(debug = false)
@Slf4j
public class HogeSpringsecurityApp extends SpringBootServletInitializer {

    @Override
    protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {
        return application.sources(HogeSpringsecurityApp.class);
    }

    public static void main(String[] args) {
        SpringApplication.run(HogeSpringsecurityApp.class, args);
    }
}
