package jp.co.ois.hoge.springsecurity.controller;

import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.Pattern;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import jp.co.ois.hoge.springsecurity.model.LoginUser;
import jp.co.ois.hoge.springsecurity.repository.EventRepository;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

/**
 * ほげ.
 */
@Controller
@RequiredArgsConstructor
@Validated
@Slf4j
public class HogeController {

    @Autowired
    private EventRepository eventRepository;
    
    @GetMapping("/")
    public String home() {
        log.debug("called.");
        return "redirect:/top";
    }

    @GetMapping("/top")
    public String top(@AuthenticationPrincipal LoginUser user) {
        log.debug("called. {}", user);
        eventRepository.insert(user.getId(), "/top");
        return "top";
    }

    @GetMapping("/hoge")
    @ResponseBody
    public String hoge(@RequestParam @Pattern(regexp = "^[x0-9]{1,20}$") String r,
            HttpServletResponse response) {
        log.info("called. {}", r);
        return "hoge ok.";
    }

}
