package jp.co.ois.hoge.springsecurity.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.web.WebAttributes;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;

import jp.co.ois.hoge.springsecurity.model.LoginUser;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

@Controller
@Slf4j
public class LoginController {

    @Data
    public static class LoginForm {
        private String username;
        private String password;
    }

    @ModelAttribute("loginForm")
    public LoginForm loginForm() {
        return new LoginForm();
    }

    @GetMapping("/login")
    public String login(Model model) {
        log.debug("called.");
        return "login";
    }

    @PostMapping("/login-failure")
    public String loginFailure(
            HttpSession session,
            HttpServletRequest request,
            Model model,
            @ModelAttribute("loginForm") LoginForm form,
            BindingResult result) {
        log.debug("called. {}", form);
        AuthenticationException authExcp = (AuthenticationException) request.getAttribute(WebAttributes.AUTHENTICATION_EXCEPTION);
        log.debug("cause: " + authExcp);
        if (authExcp instanceof InternalAuthenticationServiceException iase) {
            result.rejectValue("username", "system.error", new Object[] {iase}, null);
        } else {
            result.rejectValue("username", "auth.failed", new Object[] {authExcp.getMessage()}, null);
        }
        return "login";
    }

    private RequestCache requestCache = new HttpSessionRequestCache();

    @PostMapping("/login-success")
    public String loginSuccess(
            HttpServletRequest request,
            HttpServletResponse response,
            Model model, @AuthenticationPrincipal LoginUser user) {
        SavedRequest savedRequest = requestCache.getRequest(request, response);
        log.debug("called. {}, {}", user, savedRequest);
        if (savedRequest != null) {
            String targetUrl = savedRequest.getRedirectUrl();
            return "redirect:" + targetUrl;
        } else {
            return "redirect:/";
        }
    }

}