package jp.co.ois.hoge.springsecurity.util;

import java.util.List;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;

public class SqlLogFilter extends Filter<ILoggingEvent> {
    private static final List<String> DEFAULT_ACCEPT = List.of("insert", "update", "delete");

    private static boolean checkName(String name) {
        for (String s : DEFAULT_ACCEPT) {
            if (name.startsWith(s)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public FilterReply decide(ILoggingEvent event) {
        String loggerName = event.getLoggerName();
        if (loggerName.startsWith("jp.co.ois.hoge.springsecurity.mapper")) {
            int ix = loggerName.lastIndexOf(".");
            String name = loggerName.substring(ix + 1);
            if (!checkName(name)) {
                return FilterReply.DENY;
            }
        }
        return FilterReply.ACCEPT;
    }
}
