-- データベース設定
USE hoge_db;

CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `password` varchar(255) DEFAULT NULL,
  `role` varchar(100) NOT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_name_unique` (`name`)
) comment 'users' ;

CREATE TABLE `events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` varchar(100) NOT NULL,
  `value` varchar(100) NOT NULL,
  `created` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) comment 'events' ;

-- 初期データ
INSERT INTO users ( name ,password ,role ,created ,updated ) VALUES ( 'ois' ,'{bcrypt}$2a$10$L9EzxwQQXT3vKNeGUGXLOeW30QmcbFiwNu7RnvAXdCc.rojQRSYbu' ,'ADMIN' ,now() ,now() );

