package jp.co.ois.hoge.springsecurity.config;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;

import lombok.extern.slf4j.Slf4j;

@WebListener
@Slf4j
public class HogeContextListener implements ServletContextListener {

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        log.info("Starting.");
        ServletContext sc = sce.getServletContext();
        String metafile = "/META-INF/MANIFEST.MF";
        try (InputStream is = sc.getResourceAsStream(metafile)) {
            byte[] bytes = is.readAllBytes();
            String meta = new String(bytes, StandardCharsets.UTF_8);
            meta.lines()
                .filter(s -> s.startsWith("Implementation-Version"))
                .forEach(this::info);
        } catch (IOException e) {
            log.error(e.toString(), e);
        }
    }
    
    private void info(String s) {
        log.info(s);
    }
    
    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        log.info("Shutdown.");
    }
}
