package jp.co.ois.hoge.springsecurity.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.jboss.logging.MDC;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.CommonsRequestLoggingFilter;

import jp.co.ois.hoge.springsecurity.model.LoginUser;
import lombok.extern.slf4j.Slf4j;

@Component
@Slf4j
public class HogeLoggingFilter extends CommonsRequestLoggingFilter {

    @Override
    protected boolean shouldLog(HttpServletRequest request) {
        String uri = request.getServletPath();
        return !checkStaticPath(uri);
    }

    private boolean checkStaticPath(String path) {
        return path.startsWith("/static/");
    }

    @Override
    protected void beforeRequest(HttpServletRequest request, String message) {
        LoginUser user = getLoginUser(request.getSession(false));
        if (user != null) {
            MDC.put("USER-ID", user.getId());
        }
    }

    public LoginUser getLoginUser(HttpSession session) {
        if (session != null) {
            SecurityContext securityContext = (SecurityContext) session.getAttribute("SPRING_SECURITY_CONTEXT");
            if (securityContext != null) {
                Authentication authentication = securityContext.getAuthentication();
                return (LoginUser) authentication.getPrincipal();
            }
        }
        return null;
    }

    @Override
    protected void afterRequest(HttpServletRequest request, String message) {
        MDC.remove("USER-ID");
    }
}
