package jp.co.ois.hoge.springsecurity.repository;

import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import jp.co.ois.hoge.springsecurity.mapper.EventsMapper;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

@Repository
@Slf4j
@RequiredArgsConstructor
public class EventRepository {

    private final EventsMapper eventsMapper;

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void insert(int userId, String value) {
        eventsMapper.insert(userId, value);
    }
}
