package jp.co.ois.hoge.springsecurity.repository;

import java.util.List;

import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import jp.co.ois.hoge.springsecurity.mapper.UsersMapper;
import jp.co.ois.hoge.springsecurity.model.User;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

@Repository
@Slf4j
@RequiredArgsConstructor
public class UserRepository {

    private final UsersMapper usersMapper;

    @Transactional(readOnly = true)
    public User findByName(String name) {
        List<User> userList = usersMapper.select(name);
        if (userList.isEmpty()) {
            return null;
        } else {
            return userList.get(0);
        }
    }

    @Transactional(readOnly = true)
    public User get(int id) {
        return usersMapper.get(id);
    }

    @Transactional(propagation = Propagation.REQUIRED, rollbackFor = Exception.class)
    public void delete(int userId) {
        usersMapper.delete(userId);
    }
}
